<?php
require_once __DIR__.'/config.php';
require_once __DIR__.'/auth.php';

$u = require_user(); // না থাকলে 401 NOT_AUTH রিটার্ন করবে

function mask_email($email) {
  if (!$email) return '';
  [$name, $dom] = explode('@', $email, 2);
  $name = substr($name, 0, 2) . str_repeat('*', max(0, strlen($name)-2));
  return $name.'@'.$dom;
}

json_ok([
  'uid'       => $u['uid'],
  'email'     => mask_email($u['email']),
  'level'     => (int)($u['level'] ?? 0),
  'safeguard' => (bool)($u['safeguard'] ?? 0),
  'verified'  => (bool)($u['verified'] ?? 0),
]);
