<?php
// api/admin/add_user.php

// ---------------- CORS + JSON headers ----------------
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');

// Chrome preflight (OPTIONS) handle
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204); // no content
    exit;
}

// শুধুই POST allow করব
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed',
    ]);
    exit;
}

// ---------------- DB connect ----------------
$host = 'localhost';
$user = 'rokinyt55_signal';
$pass = 'Elon@0653';
$db   = 'rokinyt55_signal';

$mysqli = new mysqli($host, $user, $pass, $db);
if ($mysqli->connect_errno) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'DB connect error: ' . $mysqli->connect_error,
    ]);
    exit;
}

$mysqli->set_charset('utf8mb4');

// ---------------- Read JSON body ----------------
$raw  = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!is_array($data)) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid JSON body',
    ]);
    exit;
}

$name  = trim($data['name']    ?? '');
$email = trim($data['email']   ?? '');
$pass  = trim($data['password']?? '');
$role  = trim($data['role']    ?? 'user');

if ($name === '' || $email === '' || $pass === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Missing required fields',
    ]);
    exit;
}

// ---------------- Prepare values ----------------
$hash = password_hash($pass, PASSWORD_BCRYPT);

// default vip + balance
$vipLevel   = '0';
$balanceUsd = 0.0;

// ⚠️ টেবিলে যদি column-এর নাম `password_hash` থাকে,
// তাহলে নিচের query ঠিক আছে। যদি column-এর নাম শুধু `password` হয়,
// তাহলে `password_hash` এর জায়গায় `password` লিখে দিও।
$sql = "INSERT INTO users
        (name, email, password_hash, role, vip_level, balance_usd, created_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW())";

$stmt = $mysqli->prepare($sql);
if (!$stmt) {
    echo json_encode([
        'success' => false,
        'message' => 'Prepare failed: ' . $mysqli->error,
    ]);
    exit;
}

$stmt->bind_param(
    'sssssd',
    $name,
    $email,
    $hash,
    $role,
    $vipLevel,
    $balanceUsd
);

// ---------------- Execute ----------------
if (!$stmt->execute()) {
    // duplicate email হলে সুন্দর মেসেজ
    if ($stmt->errno === 1062) {
        echo json_encode([
            'success' => false,
            'message' => 'Email already exists',
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Insert failed: ' . $stmt->error,
        ]);
    }
    $stmt->close();
    exit;
}

$stmt->close();

echo json_encode([
    'success' => true,
    'message' => 'User created',
]);
