<?php
// api/admin/delete_user.php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed',
    ]);
    exit;
}

$host = 'localhost';
$user = 'rokinyt55_signal';
$pass = 'Elon@0653';
$db   = 'rokinyt55_signal';

$mysqli = new mysqli($host, $user, $pass, $db);
if ($mysqli->connect_errno) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'DB connect error: ' . $mysqli->connect_error,
    ]);
    exit;
}

$mysqli->set_charset('utf8mb4');

$raw  = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!is_array($data)) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid JSON body',
    ]);
    exit;
}

$id = intval($data['id'] ?? 0);
if ($id <= 0) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid user id',
    ]);
    exit;
}

// চাইলে এখানে root admin protect করতে পারো
// if ($id == 1) { ... }

$stmt = $mysqli->prepare("DELETE FROM users WHERE id = ? LIMIT 1");
if (!$stmt) {
    echo json_encode([
        'success' => false,
        'message' => 'Prepare failed: ' . $mysqli->error,
    ]);
    exit;
}

$stmt->bind_param('i', $id);

if (!$stmt->execute()) {
    echo json_encode([
        'success' => false,
        'message' => 'Delete failed: ' . $stmt->error,
    ]);
    $stmt->close();
    exit;
}

$stmt->close();

echo json_encode([
    'success' => true,
    'message' => 'User removed',
]);
