<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');

$host    = 'localhost';
$db      = 'rokinyt55_signal';
$user    = 'rokinyt55_signal';
$pass    = 'Elon@0653';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'DB failed','error'=>$e->getMessage()]);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!is_array($input)) $input = $_POST;

$symbol      = trim($input['symbol'] ?? '');
$base        = trim($input['base_asset'] ?? '');
$quote       = trim($input['quote_asset'] ?? '');
$type        = trim($input['type'] ?? 'perpetual');
$coingeckoId = trim($input['coingecko_id'] ?? '');
$sortOrder   = (int)($input['sort_order'] ?? 0);

if ($symbol === '' || $base === '' || $quote === '' || $coingeckoId === '') {
    echo json_encode(['success'=>false,'message'=>'Missing fields']);
    exit;
}

try {
    $stmt = $pdo->prepare(
        'INSERT INTO markets (symbol, base_asset, quote_asset, type, coingecko_id, sort_order)
         VALUES (:symbol, :base, :quote, :type, :cg, :sort)'
    );
    $stmt->execute([
        ':symbol' => $symbol,
        ':base'   => $base,
        ':quote'  => $quote,
        ':type'   => $type,
        ':cg'     => $coingeckoId,
        ':sort'   => $sortOrder,
    ]);

    echo json_encode(['success'=>true,'message'=>'Pair added']);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'message'=>'Insert failed','error'=>$e->getMessage()]);
}
