<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../config/helpers.php';
require_once __DIR__ . '/../../lib/crypto.php';
require_once __DIR__ . '/../../lib/bybit_client.php';

$input = read_input();
require_fields(['user_id','action'], $input);
$userId = (int)$input['user_id'];
$action = strtolower(trim((string)$input['action'])); // approve|reject
if ($userId <= 0) json_response(['success'=>false,'message'=>'Invalid user_id'], 400);
if (!in_array($action, ['approve','reject'], true)) json_response(['success'=>false,'message'=>'Invalid action'], 400);

// Ensure row exists
$pdo->prepare("INSERT IGNORE INTO user_trade_access (user_id) VALUES (?)")->execute([$userId]);

$stmt = $pdo->prepare("SELECT * FROM user_trade_access WHERE user_id=? LIMIT 1");
$stmt->execute([$userId]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row) json_response(['success'=>false,'message'=>'Not found'], 404);

if ($action === 'reject') {
    $pdo->prepare("UPDATE user_trade_access SET api_status='rejected', trade_unlocked=0, signal_unlocked=0, updated_at=NOW() WHERE user_id=?")->execute([$userId]);
    json_response(['success'=>true,'message'=>'Rejected']);
}

// Approve path: must have api creds
$apiKeyEnc = (string)($row['api_key_enc'] ?? '');
$apiSecretEnc = (string)($row['api_secret_enc'] ?? '');
if ($apiKeyEnc === '' || $apiSecretEnc === '') {
    json_response(['success'=>false,'message'=>'User API credentials missing'], 400);
}

$apiKey = decrypt_text($apiKeyEnc);
$apiSecret = decrypt_text($apiSecretEnc);
if ($apiKey === '' || $apiSecret === '') {
    json_response(['success'=>false,'message'=>'Could not decrypt API credentials. Check APP_CRYPT_KEY'], 500);
}

$minBalance = isset($input['min_balance']) && is_numeric($input['min_balance']) ? (float)$input['min_balance'] : 5000.0;

// Check wallet balance
$wb = bybit_private_get('/v5/account/wallet-balance', ['accountType'=>'UNIFIED','coin'=>'USDT'], $apiKey, $apiSecret);
if (!$wb['ok'] || !$wb['body_json']) {
    json_response(['success'=>false,'message'=>'Bybit request failed','error'=>$wb['error'],'http'=>$wb['http']], 502);
}
$body = $wb['body_json'];
if (!isset($body['retCode']) || (int)$body['retCode'] !== 0) {
    json_response(['success'=>false,'message'=>'Bybit error','retCode'=>$body['retCode']??null,'retMsg'=>$body['retMsg']??null,'raw'=>$body], 502);
}

$available = 0.0;
try {
    $list = $body['result']['list'] ?? [];
    if (is_array($list) && count($list) > 0) {
        $acc = $list[0];
        $usdTotal = isset($acc['totalWalletBalance']) ? (float)$acc['totalWalletBalance'] : 0.0;
        $usdtWallet = 0.0;
        $coins = $acc['coin'] ?? [];
        if (is_array($coins)) {
            foreach ($coins as $c) {
                if (($c['coin'] ?? '') === 'USDT') {
                    $usdtWallet = isset($c['walletBalance']) ? (float)$c['walletBalance'] : 0.0;
                    break;
                }
            }
        }
        $available = max($usdTotal, $usdtWallet);
    }
} catch (Throwable $e) {
    // ignore, available remains 0
}

if ($available < $minBalance) {
    json_response([
        'success'=>false,
        'message'=>'Balance too low for approval',
        'required'=> $minBalance,
        'found'=> $available,
        'bybit'=> $body,
    ], 400);
}

$pdo->prepare("UPDATE user_trade_access SET api_status='approved', trade_unlocked=1, signal_unlocked=1, updated_at=NOW() WHERE user_id=?")->execute([$userId]);

json_response([
    'success'=>true,
    'message'=>'Approved',
    'balance_checked'=> $available,
]);
