<?php
// api/admin/update_user.php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'message' => 'Method not allowed',
    ]);
    exit;
}

$host = 'localhost';
$user = 'rokinyt55_signal';
$pass = 'Elon@0653';
$db   = 'rokinyt55_signal';

$mysqli = new mysqli($host, $user, $pass, $db);
if ($mysqli->connect_errno) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'DB connect error: ' . $mysqli->connect_error,
    ]);
    exit;
}

$mysqli->set_charset('utf8mb4');

$raw  = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!is_array($data)) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid JSON body',
    ]);
    exit;
}

$id         = intval($data['id'] ?? 0);
$name       = trim($data['name'] ?? '');
$email      = trim($data['email'] ?? '');
$role       = trim($data['role'] ?? 'user');
$vipLevel   = trim($data['vip_level'] ?? '0');
$balanceUsd = floatval($data['balance_usd'] ?? 0);
$newPass    = trim($data['password'] ?? '');

if ($id <= 0 || $name === '' || $email === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Missing required fields',
    ]);
    exit;
}

$updatePassword = ($newPass !== '');
if ($updatePassword) {
    $hash = password_hash($newPass, PASSWORD_BCRYPT);
}

// ---------- query build ----------
if ($updatePassword) {
    $sql = "UPDATE users
            SET name = ?, email = ?, role = ?, vip_level = ?, balance_usd = ?, password_hash = ?
            WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    if (!$stmt) {
        echo json_encode([
            'success' => false,
            'message' => 'Prepare failed: ' . $mysqli->error,
        ]);
        exit;
    }

    $stmt->bind_param(
        'ssssdsi',
        $name,
        $email,
        $role,
        $vipLevel,
        $balanceUsd,
        $hash,
        $id
    );
} else {
    $sql = "UPDATE users
            SET name = ?, email = ?, role = ?, vip_level = ?, balance_usd = ?
            WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    if (!$stmt) {
        echo json_encode([
            'success' => false,
            'message' => 'Prepare failed: ' . $mysqli->error,
        ]);
        exit;
    }

    $stmt->bind_param(
        'ssssdi',
        $name,
        $email,
        $role,
        $vipLevel,
        $balanceUsd,
        $id
    );
}

// ---------- execute ----------
if (!$stmt->execute()) {
    if ($stmt->errno === 1062) {
        echo json_encode([
            'success' => false,
            'message' => 'Email already exists',
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Update failed: ' . $stmt->error,
        ]);
    }
    $stmt->close();
    exit;
}

$stmt->close();

echo json_encode([
    'success' => true,
    'message' => 'User updated',
]);
