<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/helpers.php';

// First admin account:
$adminEmail    = "admin@cryptokitru.com";
$adminPassword = "Admin@12345";
$adminName     = "Main Admin";

try {
    $check = $pdo->prepare("SELECT id FROM users WHERE email = :email LIMIT 1");
    $check->execute([":email" => $adminEmail]);
    if ($check->fetch()) {
        json_response([
            "success" => false,
            "message" => "Admin already exists"
        ]);
    }

    $hash = password_hash($adminPassword, PASSWORD_DEFAULT);

    $stmt = $pdo->prepare(
        "INSERT INTO users (name, email, password_hash, role)
         VALUES (:name, :email, :hash, 'admin')"
    );
    $stmt->execute([
        ":name"  => $adminName,
        ":email" => $adminEmail,
        ":hash"  => $hash,
    ]);

    json_response([
        "success" => true,
        "message" => "Admin created successfully",
        "data"    => [
            "email"    => $adminEmail,
            "password" => $adminPassword
        ]
    ]);
} catch (PDOException $e) {
    json_response([
        "success" => false,
        "message" => "Database error",
        "error"   => $e->getMessage()
    ], 500);
}
