<?php
require_once __DIR__ . '/../config/helpers.php';
require_once __DIR__ . '/../lib/bybit_client.php';

$symbol = isset($_GET['symbol']) ? strtoupper(trim((string)$_GET['symbol'])) : '';
if ($symbol === '') {
    json_response(['success'=>false,'message'=>'symbol required'], 400);
}
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;
if ($limit <= 0) $limit = 50;
if ($limit > 200) $limit = 200;

$res = bybit_public_get('/v5/market/orderbook', [
    'category' => 'linear',
    'symbol' => $symbol,
    'limit' => $limit,
]);

if (!$res['ok'] || !$res['body_json']) {
    json_response(['success'=>false,'message'=>'Bybit request failed','error'=>$res['error'], 'http'=>$res['http']], 502);
}
$body = $res['body_json'];
if (!isset($body['retCode']) || (int)$body['retCode'] !== 0) {
    json_response(['success'=>false,'message'=>'Bybit error','retCode'=>$body['retCode']??null,'retMsg'=>$body['retMsg']??null], 502);
}

json_response([
    'success'=>true,
    'data'=> $body['result'] ?? new stdClass(),
]);
