<?php
require_once __DIR__ . '/../config/helpers.php';
require_once __DIR__ . '/../lib/bybit_client.php';

// optional: ?symbol=BTCUSDT
$symbol = isset($_GET['symbol']) ? strtoupper(trim((string)$_GET['symbol'])) : '';

$query = ['category' => 'linear'];
if ($symbol !== '') $query['symbol'] = $symbol;

$res = bybit_public_get('/v5/market/tickers', $query);
if (!$res['ok'] || !$res['body_json']) {
    json_response([
        'success' => false,
        'message' => 'Bybit request failed',
        'error' => $res['error'],
        'http' => $res['http'],
    ], 502);
}

$body = $res['body_json'];
if (!isset($body['retCode']) || (int)$body['retCode'] !== 0) {
    json_response([
        'success' => false,
        'message' => 'Bybit error',
        'retCode' => $body['retCode'] ?? null,
        'retMsg'  => $body['retMsg'] ?? null,
    ], 502);
}

$list = $body['result']['list'] ?? [];
if (!is_array($list)) $list = [];

$out = [];
foreach ($list as $t) {
    $sym = strtoupper((string)($t['symbol'] ?? ''));
    if ($sym === '') continue;
    if ($symbol === '' && !str_ends_with($sym, 'USDT')) continue;

    $out[] = [
        'symbol' => $sym,
        'lastPrice' => (string)($t['lastPrice'] ?? '0'),
        'price24hPcnt' => (string)($t['price24hPcnt'] ?? '0'),
        'turnover24h' => (string)($t['turnover24h'] ?? '0'),
        'fundingRate' => (string)($t['fundingRate'] ?? ''),
        'nextFundingTime' => (string)($t['nextFundingTime'] ?? ''),
        'bid1Price' => (string)($t['bid1Price'] ?? ''),
        'ask1Price' => (string)($t['ask1Price'] ?? ''),
    ];
}

json_response([
    'success' => true,
    'source' => 'bybit_v5',
    'data' => $out,
]);
