<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
$userId = trade_resolve_user_id($pdo, $input);
$keys = trade_require_api_approved($pdo, $userId);

// Unified by default
$accountType = isset($input['accountType']) ? strtoupper(trim((string)$input['accountType'])) : 'UNIFIED';
$coin = isset($input['coin']) ? strtoupper(trim((string)$input['coin'])) : 'USDT';

$res = bybit_private_get('/v5/account/wallet-balance', [
    'accountType' => $accountType,
    'coin' => $coin,
], $keys['api_key'], $keys['api_secret']);

if (!$res['ok'] || !$res['body_json']) {
    json_response(['success'=>false,'message'=>'Bybit request failed','error'=>$res['error'],'http'=>$res['http']], 502);
}
$body = $res['body_json'];
if (!isset($body['retCode']) || (int)$body['retCode'] !== 0) {
    json_response(['success'=>false,'message'=>'Bybit error','retCode'=>$body['retCode']??null,'retMsg'=>$body['retMsg']??null,'raw'=>$body], 502);
}

$usdtAvail = bybit_pick_usdt_available_balance($body);

json_response([
    'success'=>true,
    'data'=>[
        'accountType' => $accountType,
        'coin' => $coin,
        'available_usdt' => $usdtAvail,
        'raw' => $body,
    ]
]);
