<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
$userId = trade_resolve_user_id($pdo, $input);
$keys = trade_require_api_approved($pdo, $userId);

$symbol = isset($input['symbol']) ? strtoupper(trim((string)$input['symbol'])) : '';
$settleCoin = isset($input['settleCoin']) ? strtoupper(trim((string)$input['settleCoin'])) : 'USDT';
$openOnly = isset($input['openOnly']) ? (int)$input['openOnly'] : 0;
if ($openOnly !== 0 && $openOnly !== 1) $openOnly = 0;
$limit = isset($input['limit']) ? (int)$input['limit'] : 50;
if ($limit < 1) $limit = 50; if ($limit > 50) $limit = 50;
$cursor = isset($input['cursor']) ? (string)$input['cursor'] : '';

$params = ['category'=>'linear','openOnly'=>$openOnly,'limit'=>$limit];
if ($symbol !== '') {
    $params['symbol'] = $symbol;
} else {
    // linear requires one of symbol/baseCoin/settleCoin
    $params['settleCoin'] = $settleCoin;
}
if ($cursor !== '') $params['cursor'] = $cursor;

$res = bybit_private_get('/v5/order/realtime', $params, $keys['api_key'], $keys['api_secret']);
if (!$res['ok'] || !$res['body_json']) {
    json_response(['success'=>false,'message'=>'Bybit request failed','error'=>$res['error'],'http'=>$res['http']], 502);
}
$body = $res['body_json'];
if (!isset($body['retCode']) || (int)$body['retCode'] !== 0) {
    json_response(['success'=>false,'message'=>'Bybit error','retCode'=>$body['retCode']??null,'retMsg'=>$body['retMsg']??null,'raw'=>$body], 502);
}
json_response(['success'=>true,'data'=>$body]);
