<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
require_fields(['symbol','side','orderType','qty'], $input);
$userId = trade_resolve_user_id($pdo, $input);
$keys = trade_require_api_approved($pdo, $userId);

$symbol = strtoupper(trim((string)$input['symbol']));
$side = ucfirst(strtolower(trim((string)$input['side']))); // Buy or Sell
if ($side !== 'Buy' && $side !== 'Sell') {
    json_response(['success'=>false,'message'=>'side must be Buy or Sell'], 400);
}
$orderType = ucfirst(strtolower(trim((string)$input['orderType']))); // Market/Limit
if ($orderType !== 'Market' && $orderType !== 'Limit') {
    json_response(['success'=>false,'message'=>'orderType must be Market or Limit'], 400);
}
$qty = (string)$input['qty'];
if (!is_numeric($qty) || (float)$qty <= 0) {
    json_response(['success'=>false,'message'=>'qty invalid'], 400);
}

$price = isset($input['price']) ? (string)$input['price'] : '';
if ($orderType === 'Limit') {
    if (!is_numeric($price) || (float)$price <= 0) {
        json_response(['success'=>false,'message'=>'price required for limit'], 400);
    }
}

$timeInForce = isset($input['timeInForce']) ? strtoupper(trim((string)$input['timeInForce'])) : 'GTC';
$positionIdx = isset($input['positionIdx']) && is_numeric($input['positionIdx']) ? (int)$input['positionIdx'] : 0;
$reduceOnly = !empty($input['reduceOnly']);

$leverage = isset($input['leverage']) ? (int)$input['leverage'] : 0;
if ($leverage < 0) $leverage = 0;
if ($leverage > 125) $leverage = 125;

// Optionally set leverage before placing order
$levResp = null;
if ($leverage > 0) {
    $levBody = [
        'category' => 'linear',
        'symbol' => $symbol,
        'buyLeverage' => (string)$leverage,
        'sellLeverage' => (string)$leverage,
    ];
    $tmp = bybit_private_post('/v5/position/set-leverage', $levBody, $keys['api_key'], $keys['api_secret']);
    $levResp = $tmp['body_json'] ?? null;
}

$order = [
    'category' => 'linear',
    'symbol' => $symbol,
    'side' => $side,
    'positionIdx' => $positionIdx,
    'orderType' => $orderType,
    'qty' => (string)$qty,
    'timeInForce' => $timeInForce,
    'orderLinkId' => bin2hex(random_bytes(16)),
];

if ($orderType === 'Limit') {
    $order['price'] = (string)$price;
}

if ($reduceOnly) {
    $order['reduceOnly'] = true;
}

// Bybit rule: reduceOnly=true হলে order create এর সময় TP/SL সেট করা যাবে না
$tpIn = (isset($input['takeProfit']) && is_numeric($input['takeProfit']) && (float)$input['takeProfit'] > 0);
$slIn = (isset($input['stopLoss']) && is_numeric($input['stopLoss']) && (float)$input['stopLoss'] > 0);
if ($reduceOnly && ($tpIn || $slIn)) {
    json_response(['success'=>false,'message'=>'reduceOnly order এর সাথে TP/SL একসাথে সেট করা যাবে না'], 400);
}

// TP/SL at order creation (optional)
if (isset($input['takeProfit']) && is_numeric($input['takeProfit']) && (float)$input['takeProfit'] > 0) {
    $order['takeProfit'] = (string)$input['takeProfit'];
    $order['tpTriggerBy'] = isset($input['tpTriggerBy']) ? (string)$input['tpTriggerBy'] : 'LastPrice';
}
if (isset($input['stopLoss']) && is_numeric($input['stopLoss']) && (float)$input['stopLoss'] > 0) {
    $order['stopLoss'] = (string)$input['stopLoss'];
    $order['slTriggerBy'] = isset($input['slTriggerBy']) ? (string)$input['slTriggerBy'] : 'LastPrice';
}

$res = bybit_private_post('/v5/order/create', $order, $keys['api_key'], $keys['api_secret']);
if (!$res['ok'] || !$res['body_json']) {
    json_response(['success'=>false,'message'=>'Bybit request failed','error'=>$res['error'],'http'=>$res['http']], 502);
}
$body = $res['body_json'];
if (!isset($body['retCode']) || (int)$body['retCode'] !== 0) {
    json_response(['success'=>false,'message'=>'Bybit error','retCode'=>$body['retCode']??null,'retMsg'=>$body['retMsg']??null,'raw'=>$body,'leverage_response'=>$levResp], 502);
}

json_response([
    'success'=>true,
    'data'=>[
        'order' => $body,
        'leverage_response' => $levResp,
    ],
]);
