<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
require_fields(['api_key','api_secret'], $input);
$userId = trade_resolve_user_id($pdo, $input);

$apiKey = trim((string)$input['api_key']);
$apiSecret = trim((string)$input['api_secret']);

if (strlen($apiKey) < 6 || strlen($apiSecret) < 8) {
    json_response(['success'=>false,'message'=>'Invalid API key/secret'], 400);
}

$encKey = encrypt_text($apiKey);
$encSecret = encrypt_text($apiSecret);

// upsert row
trade_ensure_access_row($pdo, $userId);

$st = $pdo->prepare(
    'UPDATE user_trade_access
     SET api_key_enc = :k, api_secret_enc = :s,
         api_status = "pending",
         trade_unlocked = IF(memo_verified=1, 1, 0),
         updated_at = NOW()
     WHERE user_id = :uid'
);
$st->execute([':k'=>$encKey, ':s'=>$encSecret, ':uid'=>$userId]);

json_response([
    'success' => true,
    'message' => 'API submitted. Waiting for admin approval.',
    'data' => [
        'user_id' => $userId,
        'api_status' => 'pending'
    ]
]);
