<?php
require_once __DIR__ . '/_trade_helpers.php';

$input = read_input();
require_fields(['memo_key'], $input);
$userId = trade_resolve_user_id($pdo, $input);

$memoInput = trim((string)$input['memo_key']);

// default memo if settings not created yet
$defaultMemo = 'WHALESKITRU19992025';
$memoServer = trade_get_setting($pdo, 'memo_key', $defaultMemo);

if ($memoInput === '' || $memoInput !== $memoServer) {
    json_response(['success'=>false,'message'=>'Invalid memo key'], 401);
}

trade_ensure_access_row($pdo, $userId);

$st = $pdo->prepare('UPDATE user_trade_access SET memo_verified=1, trade_unlocked=1, updated_at=NOW() WHERE user_id=:uid');
$st->execute([':uid'=>$userId]);

json_response([
    'success' => true,
    'message' => 'Memo verified. Trade unlocked.',
    'data' => [
        'user_id' => $userId,
        'trade_unlocked' => true,
        'memo_verified' => true,
    ]
]);
