<?php
// api/user/assets.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');

require_once __DIR__ . '/../config.php';

function send_json($arr) {
    echo json_encode($arr);
    exit;
}

try {
    $db = getDb();
} catch (Throwable $e) {
    send_json([
        'success' => false,
        'message' => 'Database connection failed',
        'error'   => $e->getMessage(),
    ]);
}

$input = json_decode(file_get_contents('php://input'), true);
$email = isset($input['email']) ? trim($input['email']) : '';

if ($email === '') {
    send_json([
        'success' => false,
        'message' => 'Email required',
    ]);
}

$stmt = $db->prepare('SELECT id FROM users WHERE email = ? LIMIT 1');
$stmt->execute([$email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    send_json([
        'success' => false,
        'message' => 'User not found',
    ]);
}

$userId = (int)$user['id'];

$stmt2 = $db->prepare('
    SELECT symbol, name, amount, usd_value, pnl_usd, pnl_percent
    FROM user_assets
    WHERE user_id = ?
    ORDER BY usd_value DESC
');
$stmt2->execute([$userId]);
$rows = $stmt2->fetchAll(PDO::FETCH_ASSOC);

send_json([
    'success' => true,
    'assets'  => $rows,
]);
