<?php
// api/wallet/get_btc_deposit.php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

$host = 'localhost';
$user = 'rokinyt55_signal';
$pass = 'Elon@0653';
$db   = 'rokinyt55_signal';

$mysqli = new mysqli($host, $user, $pass, $db);
if ($mysqli->connect_errno) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'DB connect error: ' . $mysqli->connect_error,
    ]);
    exit;
}

$mysqli->set_charset('utf8mb4');

$raw  = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!is_array($data)) {
    $data = [];
}

$email = trim($data['email'] ?? '');
$address = null;

/**
 * 1️⃣ প্রথমে user-specific address খুঁজি
 */
if ($email !== '') {
    $stmt = $mysqli->prepare(
        "SELECT address FROM btc_deposit_addresses WHERE user_email = ? LIMIT 1"
    );
    if ($stmt) {
        $stmt->bind_param('s', $email);
        if ($stmt->execute()) {
            $stmt->bind_result($addr);
            if ($stmt->fetch()) {
                $address = $addr;
            }
        }
        $stmt->close();
    }
}

/**
 * 2️⃣ না পেলে global address (user_email IS NULL বা '') নেব
 */
if ($address === null) {
    $sql = "SELECT address
            FROM btc_deposit_addresses
            WHERE user_email IS NULL OR user_email = ''
            ORDER BY id DESC
            LIMIT 1";
    $res = $mysqli->query($sql);
    if ($res && $row = $res->fetch_assoc()) {
        $address = $row['address'];
    }
}

if ($address === null) {
    $address = '';
}

// ---- BTC price (USD) CoinGecko থেকে ----
$btcPriceUsd = null;
$minUsd      = 5010.0;
$minBtc      = null;

$ctx = stream_context_create([
    'http' => [
        'timeout' => 5,
    ],
]);

$json = @file_get_contents(
    'https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=usd',
    false,
    $ctx
);

if ($json !== false) {
    $decoded = json_decode($json, true);
    if (isset($decoded['bitcoin']['usd']) && is_numeric($decoded['bitcoin']['usd'])) {
        $btcPriceUsd = (float)$decoded['bitcoin']['usd'];
        if ($btcPriceUsd > 0) {
            $minBtc = $minUsd / $btcPriceUsd;
        }
    }
}

echo json_encode([
    'success' => true,
    'data' => [
        'address'       => $address,
        'btc_price_usd' => $btcPriceUsd,
        'min_usd'       => $minUsd,
        'min_btc'       => $minBtc,
    ],
]);
