<?php
require_once __DIR__.'/config.php';

function issue_token(int $user_id, ?int $hours = 720): string {
  $token = bin2hex(random_bytes(32));
  $exp = $hours ? (new DateTime("+{$hours} hours"))->format('Y-m-d H:i:s') : null;
  $q = db()->prepare('INSERT INTO api_tokens(user_id, token, expires_at) VALUES(?,?,?)');
  $q->execute([$user_id, $token, $exp]);
  return $token;
}

function require_user(): array {
  $hdr = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
  if (!preg_match('/Bearer\\s+(\\S+)/i', $hdr, $m)) json_error('Missing bearer token', 401);
  $tok = $m[1];
  $q = db()->prepare('SELECT t.user_id, u.email, u.phone FROM api_tokens t JOIN users u ON u.id=t.user_id WHERE t.token=? AND (t.expires_at IS NULL OR t.expires_at>NOW()) LIMIT 1');
  $q->execute([$tok]);
  $row = $q->fetch();
  if (!$row) json_error('Invalid/expired token', 401);
  return $row;
}

function logout_token(string $token): void {
  $q = db()->prepare('DELETE FROM api_tokens WHERE token=?');
  $q->execute([$token]);
}
